﻿//////////////////////////////////////////////
// PixelFormat.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkImages
{
	enum class PIXEL_FORMAT
	{
		UNKNOWN_FORMAT = 0,
		R8,
		R8A8,
		R8G8B8,
		R8G8B8A8,
		B8G8R8,
		B8G8R8A8,
		R16G16B16A16,
		R32G32B32,
		R32G32B32A32,
		Y8U8V8_444,
		Y8U8Y8V8_422,
		Y8U8V8_420_SP,
		Y8Y8U8Y8Y8V8_411,
		BC1,
		BC2,
		BC3,
		BC4,
		BC5
	} ;

	class DLL_IMAGES_EXPORT PixelFormatUtils final
	{
		public :

			// Conversions
			static PIXEL_FORMAT getRgbFromBgrFormat (PIXEL_FORMAT format) ;
			static PIXEL_FORMAT getEquivalentAlphaFormat (PIXEL_FORMAT format) ;
			static PIXEL_FORMAT getEquivalentNoAlphaFormat (PIXEL_FORMAT format) ;
			static unsigned int getFormatByteSize (PIXEL_FORMAT format) ;
			static unsigned int getFormatCompressionRatioWidth (PIXEL_FORMAT format) ;
			static unsigned int getFormatCompressionRatioHeight (PIXEL_FORMAT format) ;
			static bool isFormatCompressed (PIXEL_FORMAT format) ;
			static bool isFormatFloatingPoint (PIXEL_FORMAT format) ;
			static bool hasAlpha (PIXEL_FORMAT format) ;
	} ;
}